#include <PS2X_lib.h> //for v1.6
#include <Servo.h>
PS2X ps2x; // create PS2 Controller Class

int error = 0;
byte vibrate = 0; 

#define SERV_NUM 4                  //number of servo for array
#define FRAME 20                    //interval time from current step to next step: 20msecc

int current_angle[SERV_NUM];
int target_angle[SERV_NUM + 1];
float rotating_angle[SERV_NUM];      //rotating angle on each frame: calcurated by (target_angle - current_angle)/number of steps
int servo_trim[SERV_NUM];            //trim to adjust each servo motors's angle to center

Servo servo[SERV_NUM];
#define CENTER 4
#define RIGHT 5
#define LEFT 6
#define NECK 7
#define DELAY 50

//====================================================================================================================
//Motion
//====================================================================================================================
//motion1 look around
int look_around[5][SERV_NUM + 1] = { { 0,0,0,0,500 },{ 0,0,0,60,500 },{ 0,0,0,0,500 },{ 0,0,0,-60,500 },{ 0,0,0,0,500 } };

//motion2 move forward
int move_forward[6][SERV_NUM + 1] = { { 35,0,0,0,200 },{ 35,-15,-15,0,200 },{ 0,-15,-15,0,600 },{ -35,-15,-15,0,300 },{ -35,15,15,0,400 },{ 0,15,15,0,600 } };

//motion3 move back
int move_back[6][SERV_NUM + 1] = { { -35,0,0,0,200 },{ -35,-15,-15,0,200 },{ 0,-15,-15,0,600 },{ 35,-15,-15,0,300 },{ 35,15,15,0,400 },{ 0,15,15,0,600 } };

//motion4 home position
int home_position[1][SERV_NUM + 1] = { { 0,0,0,0,300 } };
//center right reft neck
//motion5 turn right
int turn_right[7][SERV_NUM + 1] = { { 35,0,0,0,200 },{ 35,-15,0,0,200 },{ 0,-15,0,0,600 },{ -35,-15,0,0,200 },{ -35,-15,-15,0,200 },{ -35,0,0,0,200 },{ 0,0,0,0,400 } };

//motion6 turn left
int turn_left[7][SERV_NUM + 1] = { { -35,0,0,0,200 },{ -35,0,15,0,200 },{ 0,0,15,0,600 },{ 35,0,15,0,200 },{ 35,15,15,0,200 },{ 35,0,0,0,200 },{ 0,0,0,0,400 } };

//====================================================================================================================
//Servo Method
//====================================================================================================================
void initServo() {

	//attach pins to each servo
	servo[0].attach(CENTER);
	servo[1].attach(RIGHT);
	servo[2].attach(LEFT);
	servo[3].attach(NECK);

	//set trim
	int tmp_trim[SERV_NUM] = { 0,0,0,0 };      //set trim to each servo
	for (int i = 0; i<SERV_NUM; i++) {
		servo_trim[i] = tmp_trim[i];
	}
	//rotate all servos to center position
	setCenterToServo();
}

void setCenterToServo() {
	for (int i = 0; i<SERV_NUM; i++) {
		servo[i].write(90 + servo_trim[i]);
		current_angle[i] = 0;
		target_angle[i] = 0;
	}
}

//move to next position
void moveToNextPosition() {

	//check limit
	for (int i = 0; i<SERV_NUM; i++) {
		if (target_angle[i]>90) {
			target_angle[i] = 90;
		}
		else if (target_angle[i]<-90) {
			target_angle[i] = -90;
		}
	}

	int numberOfStep = target_angle[SERV_NUM] / FRAME;    //total number of steps to move to next position

	for (int i = 0; i<SERV_NUM; i++) {
		rotating_angle[i] = ((float)target_angle[i] - (float)current_angle[i]) / (float)numberOfStep;
	}

	int next_timing = millis() + FRAME;
	int current_time;
	float tmp_angle[SERV_NUM];

	for (int i = 0; i<SERV_NUM; i++) {
		tmp_angle[i] = (float)current_angle[i];
	}

	while (numberOfStep) {
		current_time = millis();
		if (current_time>next_timing) {
			for (int i = 0; i<SERV_NUM; i++) {
				tmp_angle[i] += rotating_angle[i];

				if (rotating_angle[i]<0) {
					if (current_angle[i]>target_angle[i]) {
						current_angle[i] = (int)tmp_angle[i];
					}
				}
				else if (rotating_angle[i]>0) {
					if (current_angle[i]<target_angle[i]) {
						current_angle[i] = (int)tmp_angle[i];
					}
					else {
						current_angle[i] = target_angle[i];
					}
				}
				servo[i].write(current_angle[i] + servo_trim[i] + 90);
			}
			next_timing = next_timing + FRAME;
			numberOfStep--;
		}
	}

	//adjust current_angle
	for (int i = 0; i<SERV_NUM; i++) {
		if (rotating_angle[i]<0 && current_angle[i]>target_angle[i]) {
			current_angle[i] = target_angle[i];
			servo[i].write(current_angle[i] + servo_trim[i] + 90);
		}
		else if (rotating_angle[i]>0 && current_angle[i]<target_angle[i]) {
			current_angle[i] = target_angle[i];
			servo[i].write(current_angle[i] + servo_trim[i] + 90);
		}
		else if (rotating_angle[i]<0 && current_angle[i]<target_angle[i]) {
			current_angle[i] = target_angle[i];
			servo[i].write(current_angle[i] + servo_trim[i] + 90);
		}
		else if (rotating_angle[i]>0 && current_angle[i]>target_angle[i]) {
			current_angle[i] = target_angle[i];
			servo[i].write(current_angle[i] + servo_trim[i] + 90);
		}
	}
}

//call moveToNextPosition() method continuously
void playMotion(int motion[][SERV_NUM + 1], int numberOfMotion) {

	for (int i = 0; i<numberOfMotion; i++) {
		for (int j = 0; j<SERV_NUM + 1; j++) {
			target_angle[j] = motion[i][j];
		}
		moveToNextPosition();
	}
}

void setup() {
	Serial.begin(9600);
	initServo();

	error = ps2x.config_gamepad(13, 11, 10, 12, true, true);
	//setup pins and settings: GamePad(clock, command, attention, data, Pressures?, Rumble?) check for error

	if (error == 0) {
		Serial.println("0 Found Controller, configured successful");
	}

	else if (error == 1)
		Serial.println("1 No controller found, check wiring, see readme.txt to enable debug. ");

	else if (error == 2)
		Serial.println("2 Controller found but not accepting commands. see readme.txt to enable debug. ");

	else if (error == 3)
		Serial.println("3 Controller refusing to enter Pressures mode, may not support it. ");

	//Serial.print(ps2x.Analog(1), HEX);
	Serial.println(" PS-C2 Controller Found OK! ");
}


void loop() {
	ps2x.read_gamepad(false, vibrate); 

	if (ps2x.Button(PSB_START)) { 
		Serial.println("Start");
		setCenterToServo();
	}
	else if (ps2x.Button(PSB_SELECT)) { 
	  Serial.println("Select");
	}
	else if (ps2x.Button(PSB_PAD_UP)) { 
		Serial.println("U");
		playMotion(move_forward, 6);
	}
	else if (ps2x.Button(PSB_PAD_RIGHT)) { 
		Serial.println("R");
		playMotion(turn_right, 7);
	}
	else if (ps2x.Button(PSB_PAD_LEFT)) { 
		Serial.println("L");
		playMotion(turn_left, 7);
	}
	else if (ps2x.Button(PSB_PAD_DOWN)) { 
		Serial.println("D");
		playMotion(move_back, 6);
	}
	else if (ps2x.Button(PSB_GREEN)) { 
		Serial.println("G");
    playMotion(look_around,5);
	}
	else if (ps2x.Button(PSB_RED)) { 
		Serial.println("O");
	}
	else if (ps2x.Button(PSB_PINK)) { 
		Serial.println("P");
	}
	else if (ps2x.Button(PSB_BLUE)) {
		Serial.println("X");
	}
	else if (ps2x.Button(PSB_L3)) {
		Serial.println("L3");
	}
	else if (ps2x.Button(PSB_R3)) {
		Serial.println("R3");
	}
	else if (ps2x.Button(PSB_L2)) {
		Serial.println("L2");
	}
	else if (ps2x.Button(PSB_R2)) {
		Serial.println("R2");
	}
	else if (ps2x.Button(PSB_R1)) {
		Serial.println("R1");
	}

	else if (ps2x.Button(PSB_L1))
	{
		Serial.print(ps2x.Analog(PSS_LY), DEC);
		Serial.print(",");
		Serial.print(ps2x.Analog(PSS_LX), DEC);
		Serial.print(",");
		Serial.print(ps2x.Analog(PSS_RY), DEC);
		Serial.print(",");
		Serial.println(ps2x.Analog(PSS_RX), DEC);
	}
 else {
  delay (50);
 }
	delay(50);
}
